# AICAM_Drone_YOLO_Onnx

## Overview

**AICAM_Drone_YOLO_Onnx** is a Raspberry Pi–optimized, YOLOv8 ONNX Runtime–based drone detection and recording system.
It is designed to be:

- Single-purpose (drone detection only)
- Offline-first (no network dependency)
- Reliable on Raspberry Pi (Picamera2 + ONNX Runtime CPU)
- Operationally consistent with the broader AICAM / Rasp project

The pipeline is intentionally minimal:

Picamera2 → YOLOv8 ONNX (onnxruntime) → Confirm/Gate → Clip + Logs

There is no SSD, no OpenCV DNN backend, and no detector switching.

## Requirements

- Raspberry Pi OS (Bullseye or Bookworm)
- python3-picamera2
- onnxruntime (CPU)
- libcamera-supported camera

## Model Contract

- Input: float32 [1,3,640,640]
- Output: float32 [1,5,8400]
- Single class: drone

## Basic Usage

```bash
python3 AICAM_Drone_YOLO_Only.py \
  --yolo-model /home/fry/models/best.onnx
```

## Tuned Example (recommended)

```bash
python3 AICAM_Drone_YOLO_Only.py \
  --yolo-model /home/fry/models/best.onnx \
  --annotate-clips secondary \
  --conf 0.35 \
  --min-area-px 2000 \
  --confirm-hits 4 \
  --confirm-window-s 1.5
```

## Clip Annotation Modes

- none: clean clips only
- secondary: clean + annotated clip
- burnin: overlays burned into main clip

## Virtual Environment Notes

Python virtual environments cannot reliably run preview on Raspberry Pi due to Qt/X11 limitations.
Preview should be run using system Python.
Annotated clips can be used instead when running headless or in venvs.

## Logs and Alerts

Alerts are emitted via logs and events:
- logs/aicam_drone.log
- logs/events.log
- logs/events.jsonl

TRIGGER entries indicate confirmed drone detection.

## Storage

Clips are written to:

<base_dir>/clips/

Base directory preference:
1. External writable mount
2. ~/.aicam_drone
